﻿using System;
using System.Diagnostics;
using System.Linq;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using Vimt.HealthShare.Messages.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Send Appointment to EC step.
    /// </summary>
    public class SendAppointmentToEcStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            try
            {
                foreach (var ecRequest in state.EcRequestMessages)
                {
                    var vimtRequest = PipelineUtilities.SerializeInstance(ecRequest);
                    Logger.Instance.Info($"INFO: HealthShare Make Cancel Outbound EC Request: {vimtRequest}");

                    var timer = new Stopwatch();
                    timer.Start();

                    var returnResponse = state.ResponseMessage.PatientIntegrationResultInformation.FirstOrDefault(x => x.ControlId == ecRequest.ControlId);
                    if (returnResponse == null) throw new Exception($"Cannot find Response for ControlId: {ecRequest.ControlId}");
                    returnResponse.VimtRequest = vimtRequest;

                    if (!state.UseFakeResponse)
                    {
                        var ecResponseMessage = ecRequest.SendReceive<VimtHealthShareMakeCancelOutboundResponseMessage>(MessageProcessType.Local);
                        var serializedResponse = PipelineUtilities.SerializeInstance(ecResponseMessage);
                        Logger.Instance.Info($"INFO: HealthShare Make Cancel Outbound EC Response: {serializedResponse}");

                        returnResponse.VimtResponse = PipelineUtilities.SerializeInstance(ecResponseMessage);
                        returnResponse.ExceptionOccured = ecResponseMessage.ExceptionOccured;
                        returnResponse.ExceptionMessage = ecResponseMessage.ExceptionMessage;
                    }
                    else
                    {
                        Logger.Instance.Info("**************** HealthShare MakeCancel Outbound using FAKES ****************");
                        returnResponse.VimtResponse = string.Empty;
                        returnResponse.ExceptionOccured = false;
                        returnResponse.ExceptionMessage = "********* FAKE RESPONSE *********";
                        state.ResponseMessage.VimtResponse = string.Empty;
                        state.ResponseMessage.ExceptionOccured = false;
                        state.ResponseMessage.ExceptionMessage = "********* FAKE RESPONSE *********";
                    }

                    timer.Stop();
                    returnResponse.EcProcessingMs += (int)timer.ElapsedMilliseconds;
                }
            }
            catch (Exception ex)
            {
                Logger.Instance.Error($"ERROR: HealthShare Make Cancel Outbound Send Appointment to EC Pipeline Error: {ex.Message}", ex.InnerException);
                throw new Exception($"ERROR: HealthShare Make Cancel Outbound Send Appointment to EC Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}